// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class BlockListTypeExtensions
    {
        public static string ToSerialString(this BlockListType value) => value switch
        {
            BlockListType.Committed => "committed",
            BlockListType.Uncommitted => "uncommitted",
            BlockListType.All => "all",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlockListType value.")
        };

        public static BlockListType ToBlockListType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "committed")) return BlockListType.Committed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "uncommitted")) return BlockListType.Uncommitted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "all")) return BlockListType.All;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlockListType value.");
        }
    }
}
