// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml.Linq;

namespace Azure.Storage.Blobs.Models
{
    public partial class BlockList
    {
        internal static BlockList DeserializeBlockList(XElement element)
        {
            IEnumerable<BlobBlock> committedBlocks = default;
            IEnumerable<BlobBlock> uncommittedBlocks = default;
            if (element.Element("CommittedBlocks") is XElement committedBlocksElement)
            {
                var array = new List<BlobBlock>();
                foreach (var e in committedBlocksElement.Elements("Block"))
                {
                    array.Add(BlobBlock.DeserializeBlobBlock(e));
                }
                committedBlocks = array;
            }
            if (element.Element("UncommittedBlocks") is XElement uncommittedBlocksElement)
            {
                var array = new List<BlobBlock>();
                foreach (var e in uncommittedBlocksElement.Elements("Block"))
                {
                    array.Add(BlobBlock.DeserializeBlobBlock(e));
                }
                uncommittedBlocks = array;
            }
            return new BlockList(committedBlocks, uncommittedBlocks);
        }
    }
}
