// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class BlobTypeExtensions
    {
        public static string ToSerialString(this BlobType value) => value switch
        {
            BlobType.Block => "BlockBlob",
            BlobType.Page => "PageBlob",
            BlobType.Append => "AppendBlob",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobType value.")
        };

        public static BlobType ToBlobType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BlockBlob")) return BlobType.Block;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PageBlob")) return BlobType.Page;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AppendBlob")) return BlobType.Append;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobType value.");
        }
    }
}
