// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Storage.Common;

namespace Azure.Storage.Blobs.Models
{
    /// <summary> Blob tags. </summary>
    internal partial class BlobTags
    {
        /// <summary> Initializes a new instance of <see cref="BlobTags"/>. </summary>
        /// <param name="blobTagSet"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="blobTagSet"/> is null. </exception>
        public BlobTags(IEnumerable<BlobTag> blobTagSet)
        {
            Argument.AssertNotNull(blobTagSet, nameof(blobTagSet));

            BlobTagSet = blobTagSet.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="BlobTags"/>. </summary>
        /// <param name="blobTagSet"></param>
        internal BlobTags(IList<BlobTag> blobTagSet)
        {
            BlobTagSet = blobTagSet;
        }

        /// <summary> Gets the blob tag set. </summary>
        public IList<BlobTag> BlobTagSet { get; }
    }
}
