// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml;
using System.Xml.Linq;
using Azure.Core;

namespace Azure.Storage.Blobs.Models
{
    internal partial class BlobTags : IXmlSerializable
    {
        void IXmlSerializable.Write(XmlWriter writer, string nameHint)
        {
            writer.WriteStartElement(nameHint ?? "Tags");
            writer.WriteStartElement("TagSet");
            foreach (var item in BlobTagSet)
            {
                writer.WriteObjectValue(item, "Tag");
            }
            writer.WriteEndElement();
            writer.WriteEndElement();
        }

        internal static BlobTags DeserializeBlobTags(XElement element)
        {
            IList<BlobTag> blobTagSet = default;
            if (element.Element("TagSet") is XElement tagSetElement)
            {
                var array = new List<BlobTag>();
                foreach (var e in tagSetElement.Elements("Tag"))
                {
                    array.Add(BlobTag.DeserializeBlobTag(e));
                }
                blobTagSet = array;
            }
            return new BlobTags(blobTagSet);
        }
    }
}
