// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Xml;
using System.Xml.Linq;
using Azure.Core;
using Azure.Storage.Common;

namespace Azure.Storage.Blobs.Models
{
    public partial class BlobStaticWebsite : IXmlSerializable
    {
        void IXmlSerializable.Write(XmlWriter writer, string nameHint)
        {
            writer.WriteStartElement(nameHint ?? "StaticWebsite");
            writer.WriteStartElement("Enabled");
            writer.WriteValue(Enabled);
            writer.WriteEndElement();
            if (Common.Optional.IsDefined(IndexDocument))
            {
                writer.WriteStartElement("IndexDocument");
                writer.WriteValue(IndexDocument);
                writer.WriteEndElement();
            }
            if (Common.Optional.IsDefined(ErrorDocument404Path))
            {
                writer.WriteStartElement("ErrorDocument404Path");
                writer.WriteValue(ErrorDocument404Path);
                writer.WriteEndElement();
            }
            if (Common.Optional.IsDefined(DefaultIndexDocumentPath))
            {
                writer.WriteStartElement("DefaultIndexDocumentPath");
                writer.WriteValue(DefaultIndexDocumentPath);
                writer.WriteEndElement();
            }
            writer.WriteEndElement();
        }

        internal static BlobStaticWebsite DeserializeBlobStaticWebsite(XElement element)
        {
            bool enabled = default;
            string indexDocument = default;
            string errorDocument404Path = default;
            string defaultIndexDocumentPath = default;
            if (element.Element("Enabled") is XElement enabledElement)
            {
                enabled = (bool)enabledElement;
            }
            if (element.Element("IndexDocument") is XElement indexDocumentElement)
            {
                indexDocument = (string)indexDocumentElement;
            }
            if (element.Element("ErrorDocument404Path") is XElement errorDocument404PathElement)
            {
                errorDocument404Path = (string)errorDocument404PathElement;
            }
            if (element.Element("DefaultIndexDocumentPath") is XElement defaultIndexDocumentPathElement)
            {
                defaultIndexDocumentPath = (string)defaultIndexDocumentPathElement;
            }
            return new BlobStaticWebsite(enabled, indexDocument, errorDocument404Path, defaultIndexDocumentPath);
        }
    }
}
