// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml;
using System.Xml.Linq;
using Azure.Core;
using Azure.Storage.Common;

namespace Azure.Storage.Blobs.Models
{
    public partial class BlobServiceProperties : IXmlSerializable
    {
        void IXmlSerializable.Write(XmlWriter writer, string nameHint)
        {
            writer.WriteStartElement(nameHint ?? "StorageServiceProperties");
            if (Common.Optional.IsDefined(Logging))
            {
                writer.WriteObjectValue(Logging, "Logging");
            }
            if (Common.Optional.IsDefined(HourMetrics))
            {
                writer.WriteObjectValue(HourMetrics, "HourMetrics");
            }
            if (Common.Optional.IsDefined(MinuteMetrics))
            {
                writer.WriteObjectValue(MinuteMetrics, "MinuteMetrics");
            }
            if (Common.Optional.IsDefined(DefaultServiceVersion))
            {
                writer.WriteStartElement("DefaultServiceVersion");
                writer.WriteValue(DefaultServiceVersion);
                writer.WriteEndElement();
            }
            if (Common.Optional.IsDefined(DeleteRetentionPolicy))
            {
                writer.WriteObjectValue(DeleteRetentionPolicy, "DeleteRetentionPolicy");
            }
            if (Common.Optional.IsDefined(StaticWebsite))
            {
                writer.WriteObjectValue(StaticWebsite, "StaticWebsite");
            }
            if (Common.Optional.IsCollectionDefined(Cors))
            {
                writer.WriteStartElement("Cors");
                foreach (var item in Cors)
                {
                    writer.WriteObjectValue(item, "CorsRule");
                }
                writer.WriteEndElement();
            }
            writer.WriteEndElement();
        }

        internal static BlobServiceProperties DeserializeBlobServiceProperties(XElement element)
        {
            BlobAnalyticsLogging logging = default;
            BlobMetrics hourMetrics = default;
            BlobMetrics minuteMetrics = default;
            string defaultServiceVersion = default;
            BlobRetentionPolicy deleteRetentionPolicy = default;
            BlobStaticWebsite staticWebsite = default;
            IList<BlobCorsRule> cors = default;
            if (element.Element("Logging") is XElement loggingElement)
            {
                logging = BlobAnalyticsLogging.DeserializeBlobAnalyticsLogging(loggingElement);
            }
            if (element.Element("HourMetrics") is XElement hourMetricsElement)
            {
                hourMetrics = BlobMetrics.DeserializeBlobMetrics(hourMetricsElement);
            }
            if (element.Element("MinuteMetrics") is XElement minuteMetricsElement)
            {
                minuteMetrics = BlobMetrics.DeserializeBlobMetrics(minuteMetricsElement);
            }
            if (element.Element("DefaultServiceVersion") is XElement defaultServiceVersionElement)
            {
                defaultServiceVersion = (string)defaultServiceVersionElement;
            }
            if (element.Element("DeleteRetentionPolicy") is XElement deleteRetentionPolicyElement)
            {
                deleteRetentionPolicy = BlobRetentionPolicy.DeserializeBlobRetentionPolicy(deleteRetentionPolicyElement);
            }
            if (element.Element("StaticWebsite") is XElement staticWebsiteElement)
            {
                staticWebsite = BlobStaticWebsite.DeserializeBlobStaticWebsite(staticWebsiteElement);
            }
            if (element.Element("Cors") is XElement corsElement)
            {
                var array = new List<BlobCorsRule>();
                foreach (var e in corsElement.Elements("CorsRule"))
                {
                    array.Add(BlobCorsRule.DeserializeBlobCorsRule(e));
                }
                cors = array;
            }
            return new BlobServiceProperties(
                logging,
                hourMetrics,
                minuteMetrics,
                cors,
                defaultServiceVersion,
                deleteRetentionPolicy,
                staticWebsite);
        }
    }
}
