// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Storage.Common;

namespace Azure.Storage.Blobs.Models
{
    /// <summary> The BlobHierarchyListSegment. </summary>
    internal partial class BlobHierarchyListSegment
    {
        /// <summary> Initializes a new instance of <see cref="BlobHierarchyListSegment"/>. </summary>
        /// <param name="blobItems"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="blobItems"/> is null. </exception>
        internal BlobHierarchyListSegment(IEnumerable<BlobItemInternal> blobItems)
        {
            Argument.AssertNotNull(blobItems, nameof(blobItems));

            BlobPrefixes = new ChangeTrackingList<BlobPrefix>();
            BlobItems = blobItems.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="BlobHierarchyListSegment"/>. </summary>
        /// <param name="blobPrefixes"></param>
        /// <param name="blobItems"></param>
        internal BlobHierarchyListSegment(IReadOnlyList<BlobPrefix> blobPrefixes, IReadOnlyList<BlobItemInternal> blobItems)
        {
            BlobPrefixes = blobPrefixes;
            BlobItems = blobItems;
        }

        /// <summary> Gets the blob prefixes. </summary>
        public IReadOnlyList<BlobPrefix> BlobPrefixes { get; }
        /// <summary> Gets the blob items. </summary>
        public IReadOnlyList<BlobItemInternal> BlobItems { get; }
    }
}
