// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class BlobGeoReplicationStatusExtensions
    {
        public static string ToSerialString(this BlobGeoReplicationStatus value) => value switch
        {
            BlobGeoReplicationStatus.Live => "live",
            BlobGeoReplicationStatus.Bootstrap => "bootstrap",
            BlobGeoReplicationStatus.Unavailable => "unavailable",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobGeoReplicationStatus value.")
        };

        public static BlobGeoReplicationStatus ToBlobGeoReplicationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "live")) return BlobGeoReplicationStatus.Live;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "bootstrap")) return BlobGeoReplicationStatus.Bootstrap;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "unavailable")) return BlobGeoReplicationStatus.Unavailable;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobGeoReplicationStatus value.");
        }
    }
}
