// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    /// <summary> Geo-Replication information for the Secondary Storage Service. </summary>
    public partial class BlobGeoReplication
    {
        /// <summary> Initializes a new instance of <see cref="BlobGeoReplication"/>. </summary>
        /// <param name="status"> The status of the secondary location. </param>
        /// <param name="lastSyncedOn"> A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for read operations at the secondary. Primary writes after this point in time may or may not be available for reads. </param>
        internal BlobGeoReplication(BlobGeoReplicationStatus status, DateTimeOffset? lastSyncedOn)
        {
            Status = status;
            LastSyncedOn = lastSyncedOn;
        }

        /// <summary> The status of the secondary location. </summary>
        public BlobGeoReplicationStatus Status { get; }
    }
}
