// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Storage.Common;

namespace Azure.Storage.Blobs.Models
{
    /// <summary> The BlobFlatListSegment. </summary>
    internal partial class BlobFlatListSegment
    {
        /// <summary> Initializes a new instance of <see cref="BlobFlatListSegment"/>. </summary>
        /// <param name="blobItems"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="blobItems"/> is null. </exception>
        internal BlobFlatListSegment(IEnumerable<BlobItemInternal> blobItems)
        {
            Argument.AssertNotNull(blobItems, nameof(blobItems));

            BlobItems = blobItems.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="BlobFlatListSegment"/>. </summary>
        /// <param name="blobItems"></param>
        internal BlobFlatListSegment(IReadOnlyList<BlobItemInternal> blobItems)
        {
            BlobItems = blobItems;
        }

        /// <summary> Gets the blob items. </summary>
        public IReadOnlyList<BlobItemInternal> BlobItems { get; }
    }
}
