// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class BlobDeleteTypeExtensions
    {
        public static string ToSerialString(this BlobDeleteType value) => value switch
        {
            BlobDeleteType.None => "None",
            BlobDeleteType.Permanent => "Permanent",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobDeleteType value.")
        };

        public static BlobDeleteType ToBlobDeleteType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return BlobDeleteType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Permanent")) return BlobDeleteType.Permanent;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobDeleteType value.");
        }
    }
}
