// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class BlobCopySourceTagsModeExtensions
    {
        public static string ToSerialString(this BlobCopySourceTagsMode value) => value switch
        {
            BlobCopySourceTagsMode.Replace => "REPLACE",
            BlobCopySourceTagsMode.Copy => "COPY",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobCopySourceTagsMode value.")
        };

        public static BlobCopySourceTagsMode ToBlobCopySourceTagsMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "REPLACE")) return BlobCopySourceTagsMode.Replace;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "COPY")) return BlobCopySourceTagsMode.Copy;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BlobCopySourceTagsMode value.");
        }
    }
}
