// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Storage.Common;

namespace Azure.Storage.Blobs.Models
{
    /// <summary> Groups settings regarding specific field of an arrow schema. </summary>
    internal partial class ArrowFieldInternal
    {
        /// <summary> Initializes a new instance of <see cref="ArrowFieldInternal"/>. </summary>
        /// <param name="type"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="type"/> is null. </exception>
        public ArrowFieldInternal(string type)
        {
            Argument.AssertNotNull(type, nameof(type));

            Type = type;
        }

        /// <summary> Initializes a new instance of <see cref="ArrowFieldInternal"/>. </summary>
        /// <param name="type"></param>
        /// <param name="name"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        internal ArrowFieldInternal(string type, string name, int? precision, int? scale)
        {
            Type = type;
            Name = name;
            Precision = precision;
            Scale = scale;
        }

        /// <summary> Gets the type. </summary>
        public string Type { get; }
        /// <summary> Gets or sets the name. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets the precision. </summary>
        public int? Precision { get; set; }
        /// <summary> Gets or sets the scale. </summary>
        public int? Scale { get; set; }
    }
}
