// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class ArchiveStatusExtensions
    {
        public static string ToSerialString(this ArchiveStatus value) => value switch
        {
            ArchiveStatus.RehydratePendingToHot => "rehydrate-pending-to-hot",
            ArchiveStatus.RehydratePendingToCool => "rehydrate-pending-to-cool",
            ArchiveStatus.RehydratePendingToCold => "rehydrate-pending-to-cold",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArchiveStatus value.")
        };

        public static ArchiveStatus ToArchiveStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "rehydrate-pending-to-hot")) return ArchiveStatus.RehydratePendingToHot;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "rehydrate-pending-to-cool")) return ArchiveStatus.RehydratePendingToCool;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "rehydrate-pending-to-cold")) return ArchiveStatus.RehydratePendingToCold;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArchiveStatus value.");
        }
    }
}
