// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class AccountKindExtensions
    {
        public static string ToSerialString(this AccountKind value) => value switch
        {
            AccountKind.Storage => "Storage",
            AccountKind.BlobStorage => "BlobStorage",
            AccountKind.StorageV2 => "StorageV2",
            AccountKind.FileStorage => "FileStorage",
            AccountKind.BlockBlobStorage => "BlockBlobStorage",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AccountKind value.")
        };

        public static AccountKind ToAccountKind(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Storage")) return AccountKind.Storage;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BlobStorage")) return AccountKind.BlobStorage;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StorageV2")) return AccountKind.StorageV2;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "FileStorage")) return AccountKind.FileStorage;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BlockBlobStorage")) return AccountKind.BlockBlobStorage;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AccountKind value.");
        }
    }
}
