// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.Storage.Blobs.Models;

namespace Azure.Storage.Blobs
{
    internal partial class ContainerGetPropertiesHeaders
    {
        private readonly Response _response;
        public ContainerGetPropertiesHeaders(Response response)
        {
            _response = response;
        }
        public IDictionary<string, string> Metadata => _response.Headers.TryGetValue("x-ms-meta-", out IDictionary<string, string> value) ? value : null;
        /// <summary> Returns the date and time the container was last modified. Any operation that modifies the blob, including an update of the blob's metadata or properties, changes the last-modified time of the blob. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> When a blob is leased, specifies whether the lease is of infinite or fixed duration. </summary>
        public LeaseDurationType? LeaseDuration => _response.Headers.TryGetValue("x-ms-lease-duration", out string value) ? value.ToLeaseDurationType() : null;
        /// <summary> Lease state of the blob. </summary>
        public LeaseState? LeaseState => _response.Headers.TryGetValue("x-ms-lease-state", out string value) ? value.ToLeaseState() : null;
        /// <summary> The current lease status of the blob. </summary>
        public LeaseStatus? LeaseStatus => _response.Headers.TryGetValue("x-ms-lease-status", out string value) ? value.ToLeaseStatus() : null;
        /// <summary> Indicates the version of the Blob service used to execute the request. This header is returned for requests made against version 2009-09-19 and above. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> Indicated whether data in the container may be accessed publicly and the level of access. </summary>
        public PublicAccessType? BlobPublicAccess => _response.Headers.TryGetValue("x-ms-blob-public-access", out string value) ? value.ToPublicAccessType() : null;
        /// <summary> Indicates whether the container has an immutability policy set on it. </summary>
        public bool? HasImmutabilityPolicy => _response.Headers.TryGetValue("x-ms-has-immutability-policy", out bool? value) ? value : null;
        /// <summary> Indicates whether the container has a legal hold. </summary>
        public bool? HasLegalHold => _response.Headers.TryGetValue("x-ms-has-legal-hold", out bool? value) ? value : null;
        /// <summary> The default encryption scope for the container. </summary>
        public string DefaultEncryptionScope => _response.Headers.TryGetValue("x-ms-default-encryption-scope", out string value) ? value : null;
        /// <summary> Indicates whether the container's default encryption scope can be overriden. </summary>
        public bool? DenyEncryptionScopeOverride => _response.Headers.TryGetValue("x-ms-deny-encryption-scope-override", out bool? value) ? value : null;
        /// <summary> Indicates whether version level worm is enabled on a container. </summary>
        public bool? IsImmutableStorageWithVersioningEnabled => _response.Headers.TryGetValue("x-ms-immutable-storage-with-versioning-enabled", out bool? value) ? value : null;
    }
}
