// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;
using Azure.Storage.Blobs.Models;

namespace Azure.Storage.Blobs
{
    internal partial class ContainerGetAccessPolicyHeaders
    {
        private readonly Response _response;
        public ContainerGetAccessPolicyHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Indicated whether data in the container may be accessed publicly and the level of access. </summary>
        public PublicAccessType? BlobPublicAccess => _response.Headers.TryGetValue("x-ms-blob-public-access", out string value) ? value.ToPublicAccessType() : null;
        /// <summary> Returns the date and time the container was last modified. Any operation that modifies the blob, including an update of the blob's metadata or properties, changes the last-modified time of the blob. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> Indicates the version of the Blob service used to execute the request. This header is returned for requests made against version 2009-09-19 and above. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
    }
}
