// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Storage.Blobs.Batch.Models
{
    /// <summary> The BatchAccessTier. </summary>
    internal readonly partial struct BatchAccessTier : IEquatable<BatchAccessTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchAccessTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchAccessTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P4Value = "P4";
        private const string P6Value = "P6";
        private const string P10Value = "P10";
        private const string P15Value = "P15";
        private const string P20Value = "P20";
        private const string P30Value = "P30";
        private const string P40Value = "P40";
        private const string P50Value = "P50";
        private const string P60Value = "P60";
        private const string P70Value = "P70";
        private const string P80Value = "P80";
        private const string HotValue = "Hot";
        private const string CoolValue = "Cool";
        private const string ArchiveValue = "Archive";

        /// <summary> P4. </summary>
        public static BatchAccessTier P4 { get; } = new BatchAccessTier(P4Value);
        /// <summary> P6. </summary>
        public static BatchAccessTier P6 { get; } = new BatchAccessTier(P6Value);
        /// <summary> P10. </summary>
        public static BatchAccessTier P10 { get; } = new BatchAccessTier(P10Value);
        /// <summary> P15. </summary>
        public static BatchAccessTier P15 { get; } = new BatchAccessTier(P15Value);
        /// <summary> P20. </summary>
        public static BatchAccessTier P20 { get; } = new BatchAccessTier(P20Value);
        /// <summary> P30. </summary>
        public static BatchAccessTier P30 { get; } = new BatchAccessTier(P30Value);
        /// <summary> P40. </summary>
        public static BatchAccessTier P40 { get; } = new BatchAccessTier(P40Value);
        /// <summary> P50. </summary>
        public static BatchAccessTier P50 { get; } = new BatchAccessTier(P50Value);
        /// <summary> P60. </summary>
        public static BatchAccessTier P60 { get; } = new BatchAccessTier(P60Value);
        /// <summary> P70. </summary>
        public static BatchAccessTier P70 { get; } = new BatchAccessTier(P70Value);
        /// <summary> P80. </summary>
        public static BatchAccessTier P80 { get; } = new BatchAccessTier(P80Value);
        /// <summary> Hot. </summary>
        public static BatchAccessTier Hot { get; } = new BatchAccessTier(HotValue);
        /// <summary> Cool. </summary>
        public static BatchAccessTier Cool { get; } = new BatchAccessTier(CoolValue);
        /// <summary> Archive. </summary>
        public static BatchAccessTier Archive { get; } = new BatchAccessTier(ArchiveValue);
        /// <summary> Determines if two <see cref="BatchAccessTier"/> values are the same. </summary>
        public static bool operator ==(BatchAccessTier left, BatchAccessTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchAccessTier"/> values are not the same. </summary>
        public static bool operator !=(BatchAccessTier left, BatchAccessTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchAccessTier"/>. </summary>
        public static implicit operator BatchAccessTier(string value) => new BatchAccessTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchAccessTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchAccessTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
