// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage
{
    /// <summary>
    /// A class representing the Table data model.
    /// Properties of the table, including Id, resource name, resource type.
    /// </summary>
    public partial class TableData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TableData"/>. </summary>
        public TableData()
        {
            SignedIdentifiers = new ChangeTrackingList<StorageTableSignedIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="TableData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tableName"> Table name under the specified account. </param>
        /// <param name="signedIdentifiers"> List of stored access policies specified on the table. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TableData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string tableName, IList<StorageTableSignedIdentifier> signedIdentifiers, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            TableName = tableName;
            SignedIdentifiers = signedIdentifiers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Table name under the specified account. </summary>
        [WirePath("properties.tableName")]
        public string TableName { get; }
        /// <summary> List of stored access policies specified on the table. </summary>
        [WirePath("properties.signedIdentifiers")]
        public IList<StorageTableSignedIdentifier> SignedIdentifiers { get; }
    }
}
