// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage
{
    public partial class StorageAccountLocalUserData : IUtf8JsonSerializable, IJsonModel<StorageAccountLocalUserData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageAccountLocalUserData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageAccountLocalUserData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageAccountLocalUserData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageAccountLocalUserData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(PermissionScopes))
            {
                writer.WritePropertyName("permissionScopes"u8);
                writer.WriteStartArray();
                foreach (var item in PermissionScopes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HomeDirectory))
            {
                writer.WritePropertyName("homeDirectory"u8);
                writer.WriteStringValue(HomeDirectory);
            }
            if (Optional.IsCollectionDefined(SshAuthorizedKeys))
            {
                writer.WritePropertyName("sshAuthorizedKeys"u8);
                writer.WriteStartArray();
                foreach (var item in SshAuthorizedKeys)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Sid))
            {
                writer.WritePropertyName("sid"u8);
                writer.WriteStringValue(Sid);
            }
            if (Optional.IsDefined(HasSharedKey))
            {
                writer.WritePropertyName("hasSharedKey"u8);
                writer.WriteBooleanValue(HasSharedKey.Value);
            }
            if (Optional.IsDefined(HasSshKey))
            {
                writer.WritePropertyName("hasSshKey"u8);
                writer.WriteBooleanValue(HasSshKey.Value);
            }
            if (Optional.IsDefined(HasSshPassword))
            {
                writer.WritePropertyName("hasSshPassword"u8);
                writer.WriteBooleanValue(HasSshPassword.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UserId))
            {
                writer.WritePropertyName("userId"u8);
                writer.WriteNumberValue(UserId.Value);
            }
            if (Optional.IsDefined(GroupId))
            {
                writer.WritePropertyName("groupId"u8);
                writer.WriteNumberValue(GroupId.Value);
            }
            if (Optional.IsDefined(IsAclAuthorizationAllowed))
            {
                writer.WritePropertyName("allowAclAuthorization"u8);
                writer.WriteBooleanValue(IsAclAuthorizationAllowed.Value);
            }
            if (Optional.IsCollectionDefined(ExtendedGroups))
            {
                writer.WritePropertyName("extendedGroups"u8);
                writer.WriteStartArray();
                foreach (var item in ExtendedGroups)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsNfsV3Enabled))
            {
                writer.WritePropertyName("isNFSv3Enabled"u8);
                writer.WriteBooleanValue(IsNfsV3Enabled.Value);
            }
            writer.WriteEndObject();
        }

        StorageAccountLocalUserData IJsonModel<StorageAccountLocalUserData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageAccountLocalUserData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageAccountLocalUserData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageAccountLocalUserData(document.RootElement, options);
        }

        internal static StorageAccountLocalUserData DeserializeStorageAccountLocalUserData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IList<StoragePermissionScope> permissionScopes = default;
            string homeDirectory = default;
            IList<StorageSshPublicKey> sshAuthorizedKeys = default;
            string sid = default;
            bool? hasSharedKey = default;
            bool? hasSshKey = default;
            bool? hasSshPassword = default;
            int? userId = default;
            int? groupId = default;
            bool? allowAclAuthorization = default;
            IList<int> extendedGroups = default;
            bool? isNFSv3Enabled = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("permissionScopes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<StoragePermissionScope> array = new List<StoragePermissionScope>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(StoragePermissionScope.DeserializeStoragePermissionScope(item, options));
                            }
                            permissionScopes = array;
                            continue;
                        }
                        if (property0.NameEquals("homeDirectory"u8))
                        {
                            homeDirectory = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sshAuthorizedKeys"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<StorageSshPublicKey> array = new List<StorageSshPublicKey>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(StorageSshPublicKey.DeserializeStorageSshPublicKey(item, options));
                            }
                            sshAuthorizedKeys = array;
                            continue;
                        }
                        if (property0.NameEquals("sid"u8))
                        {
                            sid = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("hasSharedKey"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hasSharedKey = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("hasSshKey"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hasSshKey = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("hasSshPassword"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hasSshPassword = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("userId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            userId = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("groupId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            groupId = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("allowAclAuthorization"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allowAclAuthorization = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("extendedGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<int> array = new List<int>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetInt32());
                            }
                            extendedGroups = array;
                            continue;
                        }
                        if (property0.NameEquals("isNFSv3Enabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isNFSv3Enabled = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageAccountLocalUserData(
                id,
                name,
                type,
                systemData,
                permissionScopes ?? new ChangeTrackingList<StoragePermissionScope>(),
                homeDirectory,
                sshAuthorizedKeys ?? new ChangeTrackingList<StorageSshPublicKey>(),
                sid,
                hasSharedKey,
                hasSshKey,
                hasSshPassword,
                userId,
                groupId,
                allowAclAuthorization,
                extendedGroups ?? new ChangeTrackingList<int>(),
                isNFSv3Enabled,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PermissionScopes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    permissionScopes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PermissionScopes))
                {
                    if (PermissionScopes.Any())
                    {
                        builder.Append("    permissionScopes: ");
                        builder.AppendLine("[");
                        foreach (var item in PermissionScopes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    permissionScopes: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HomeDirectory), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    homeDirectory: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HomeDirectory))
                {
                    builder.Append("    homeDirectory: ");
                    if (HomeDirectory.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{HomeDirectory}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{HomeDirectory}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SshAuthorizedKeys), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sshAuthorizedKeys: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SshAuthorizedKeys))
                {
                    if (SshAuthorizedKeys.Any())
                    {
                        builder.Append("    sshAuthorizedKeys: ");
                        builder.AppendLine("[");
                        foreach (var item in SshAuthorizedKeys)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    sshAuthorizedKeys: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Sid))
                {
                    builder.Append("    sid: ");
                    if (Sid.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Sid}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Sid}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HasSharedKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    hasSharedKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HasSharedKey))
                {
                    builder.Append("    hasSharedKey: ");
                    var boolValue = HasSharedKey.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HasSshKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    hasSshKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HasSshKey))
                {
                    builder.Append("    hasSshKey: ");
                    var boolValue = HasSshKey.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HasSshPassword), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    hasSshPassword: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HasSshPassword))
                {
                    builder.Append("    hasSshPassword: ");
                    var boolValue = HasSshPassword.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    userId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UserId))
                {
                    builder.Append("    userId: ");
                    builder.AppendLine($"{UserId.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    groupId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GroupId))
                {
                    builder.Append("    groupId: ");
                    builder.AppendLine($"{GroupId.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsAclAuthorizationAllowed), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    allowAclAuthorization: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsAclAuthorizationAllowed))
                {
                    builder.Append("    allowAclAuthorization: ");
                    var boolValue = IsAclAuthorizationAllowed.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExtendedGroups), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    extendedGroups: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ExtendedGroups))
                {
                    if (ExtendedGroups.Any())
                    {
                        builder.Append("    extendedGroups: ");
                        builder.AppendLine("[");
                        foreach (var item in ExtendedGroups)
                        {
                            builder.AppendLine($"      {item}");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsNfsV3Enabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isNFSv3Enabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsNfsV3Enabled))
                {
                    builder.Append("    isNFSv3Enabled: ");
                    var boolValue = IsNfsV3Enabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<StorageAccountLocalUserData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageAccountLocalUserData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(StorageAccountLocalUserData)} does not support writing '{options.Format}' format.");
            }
        }

        StorageAccountLocalUserData IPersistableModel<StorageAccountLocalUserData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageAccountLocalUserData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageAccountLocalUserData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageAccountLocalUserData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageAccountLocalUserData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
