// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage
{
    /// <summary>
    /// A class representing the ObjectReplicationPolicy data model.
    /// The replication policy between two storage accounts. Multiple rules can be defined in one policy.
    /// </summary>
    public partial class ObjectReplicationPolicyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ObjectReplicationPolicyData"/>. </summary>
        public ObjectReplicationPolicyData()
        {
            Rules = new ChangeTrackingList<ObjectReplicationPolicyRule>();
        }

        /// <summary> Initializes a new instance of <see cref="ObjectReplicationPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyId"> A unique id for object replication policy. </param>
        /// <param name="enabledOn"> Indicates when the policy is enabled on the source account. </param>
        /// <param name="sourceAccount"> Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false. </param>
        /// <param name="destinationAccount"> Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false. </param>
        /// <param name="rules"> The storage account object replication rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ObjectReplicationPolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string policyId, DateTimeOffset? enabledOn, string sourceAccount, string destinationAccount, IList<ObjectReplicationPolicyRule> rules, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PolicyId = policyId;
            EnabledOn = enabledOn;
            SourceAccount = sourceAccount;
            DestinationAccount = destinationAccount;
            Rules = rules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A unique id for object replication policy. </summary>
        [WirePath("properties.policyId")]
        public string PolicyId { get; }
        /// <summary> Indicates when the policy is enabled on the source account. </summary>
        [WirePath("properties.enabledTime")]
        public DateTimeOffset? EnabledOn { get; }
        /// <summary> Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false. </summary>
        [WirePath("properties.sourceAccount")]
        public string SourceAccount { get; set; }
        /// <summary> Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false. </summary>
        [WirePath("properties.destinationAccount")]
        public string DestinationAccount { get; set; }
        /// <summary> The storage account object replication rules. </summary>
        [WirePath("properties.rules")]
        public IList<ObjectReplicationPolicyRule> Rules { get; }
    }
}
