// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Storage.Models
{
    internal static partial class StorageUsageUnitExtensions
    {
        public static string ToSerialString(this StorageUsageUnit value) => value switch
        {
            StorageUsageUnit.Count => "Count",
            StorageUsageUnit.Bytes => "Bytes",
            StorageUsageUnit.Seconds => "Seconds",
            StorageUsageUnit.Percent => "Percent",
            StorageUsageUnit.CountsPerSecond => "CountsPerSecond",
            StorageUsageUnit.BytesPerSecond => "BytesPerSecond",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageUsageUnit value.")
        };

        public static StorageUsageUnit ToStorageUsageUnit(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Count")) return StorageUsageUnit.Count;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Bytes")) return StorageUsageUnit.Bytes;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Seconds")) return StorageUsageUnit.Seconds;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Percent")) return StorageUsageUnit.Percent;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CountsPerSecond")) return StorageUsageUnit.CountsPerSecond;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BytesPerSecond")) return StorageUsageUnit.BytesPerSecond;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageUsageUnit value.");
        }
    }
}
