// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Represents the status of the execution. </summary>
    public readonly partial struct StorageTaskRunStatus : IEquatable<StorageTaskRunStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageTaskRunStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageTaskRunStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "InProgress";
        private const string FinishedValue = "Finished";

        /// <summary> InProgress. </summary>
        public static StorageTaskRunStatus InProgress { get; } = new StorageTaskRunStatus(InProgressValue);
        /// <summary> Finished. </summary>
        public static StorageTaskRunStatus Finished { get; } = new StorageTaskRunStatus(FinishedValue);
        /// <summary> Determines if two <see cref="StorageTaskRunStatus"/> values are the same. </summary>
        public static bool operator ==(StorageTaskRunStatus left, StorageTaskRunStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageTaskRunStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageTaskRunStatus left, StorageTaskRunStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageTaskRunStatus"/>. </summary>
        public static implicit operator StorageTaskRunStatus(string value) => new StorageTaskRunStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageTaskRunStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageTaskRunStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
