// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Storage task execution report for a run instance. </summary>
    public partial class StorageTaskReportProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageTaskReportProperties"/>. </summary>
        public StorageTaskReportProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskReportProperties"/>. </summary>
        /// <param name="taskAssignmentId"> Represents the Storage Task Assignment Id associated with the storage task that provided an execution context. </param>
        /// <param name="storageAccountId"> Represents the Storage Account Id where the storage task definition was applied and executed. </param>
        /// <param name="startedOn"> Start time of the run instance. Filter options such as startTime gt '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for DateTime properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </param>
        /// <param name="finishedOn"> End time of the run instance. Filter options such as startTime gt '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for DateTime properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </param>
        /// <param name="objectsTargetedCount"> Total number of objects that meet the condition as defined in the storage task assignment execution context. Filter options such as objectsTargetedCount gt 50 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </param>
        /// <param name="objectsOperatedOnCount"> Total number of objects that meet the storage tasks condition and were operated upon. Filter options such as objectsOperatedOnCount ge 100 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </param>
        /// <param name="objectFailedCount"> Total number of objects where task operation failed when was attempted. Filter options such as objectFailedCount eq 0 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </param>
        /// <param name="objectsSucceededCount"> Total number of objects where task operation succeeded when was attempted.Filter options such as objectsSucceededCount gt 150 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </param>
        /// <param name="runStatusError"> Well known Azure Storage error code that represents the error encountered during execution of the run instance. </param>
        /// <param name="runStatusEnum"> Represents the status of the execution. </param>
        /// <param name="summaryReportPath"> Full path to the verbose report stored in the reporting container as specified in the assignment execution context for the storage account. </param>
        /// <param name="taskId"> Storage Task Arm Id. </param>
        /// <param name="taskVersion"> Storage Task Version. </param>
        /// <param name="runResult"> Represents the overall result of the execution for the run instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageTaskReportProperties(ResourceIdentifier taskAssignmentId, ResourceIdentifier storageAccountId, DateTimeOffset? startedOn, DateTimeOffset? finishedOn, string objectsTargetedCount, string objectsOperatedOnCount, string objectFailedCount, string objectsSucceededCount, string runStatusError, StorageTaskRunStatus? runStatusEnum, string summaryReportPath, ResourceIdentifier taskId, string taskVersion, StorageTaskRunResult? runResult, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TaskAssignmentId = taskAssignmentId;
            StorageAccountId = storageAccountId;
            StartedOn = startedOn;
            FinishedOn = finishedOn;
            ObjectsTargetedCount = objectsTargetedCount;
            ObjectsOperatedOnCount = objectsOperatedOnCount;
            ObjectFailedCount = objectFailedCount;
            ObjectsSucceededCount = objectsSucceededCount;
            RunStatusError = runStatusError;
            RunStatusEnum = runStatusEnum;
            SummaryReportPath = summaryReportPath;
            TaskId = taskId;
            TaskVersion = taskVersion;
            RunResult = runResult;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents the Storage Task Assignment Id associated with the storage task that provided an execution context. </summary>
        [WirePath("taskAssignmentId")]
        public ResourceIdentifier TaskAssignmentId { get; }
        /// <summary> Represents the Storage Account Id where the storage task definition was applied and executed. </summary>
        [WirePath("storageAccountId")]
        public ResourceIdentifier StorageAccountId { get; }
        /// <summary> Start time of the run instance. Filter options such as startTime gt '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for DateTime properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartedOn { get; }
        /// <summary> End time of the run instance. Filter options such as startTime gt '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for DateTime properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </summary>
        [WirePath("finishTime")]
        public DateTimeOffset? FinishedOn { get; }
        /// <summary> Total number of objects that meet the condition as defined in the storage task assignment execution context. Filter options such as objectsTargetedCount gt 50 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </summary>
        [WirePath("objectsTargetedCount")]
        public string ObjectsTargetedCount { get; }
        /// <summary> Total number of objects that meet the storage tasks condition and were operated upon. Filter options such as objectsOperatedOnCount ge 100 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </summary>
        [WirePath("objectsOperatedOnCount")]
        public string ObjectsOperatedOnCount { get; }
        /// <summary> Total number of objects where task operation failed when was attempted. Filter options such as objectFailedCount eq 0 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </summary>
        [WirePath("objectFailedCount")]
        public string ObjectFailedCount { get; }
        /// <summary> Total number of objects where task operation succeeded when was attempted.Filter options such as objectsSucceededCount gt 150 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators. </summary>
        [WirePath("objectsSucceededCount")]
        public string ObjectsSucceededCount { get; }
        /// <summary> Well known Azure Storage error code that represents the error encountered during execution of the run instance. </summary>
        [WirePath("runStatusError")]
        public string RunStatusError { get; }
        /// <summary> Represents the status of the execution. </summary>
        [WirePath("runStatusEnum")]
        public StorageTaskRunStatus? RunStatusEnum { get; }
        /// <summary> Full path to the verbose report stored in the reporting container as specified in the assignment execution context for the storage account. </summary>
        [WirePath("summaryReportPath")]
        public string SummaryReportPath { get; }
        /// <summary> Storage Task Arm Id. </summary>
        [WirePath("taskId")]
        public ResourceIdentifier TaskId { get; }
        /// <summary> Storage Task Version. </summary>
        [WirePath("taskVersion")]
        public string TaskVersion { get; }
        /// <summary> Represents the overall result of the execution for the run instance. </summary>
        [WirePath("runResult")]
        public StorageTaskRunResult? RunResult { get; }
    }
}
