// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Execution context of the storage task assignment. </summary>
    public partial class StorageTaskAssignmentExecutionContext
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentExecutionContext"/>. </summary>
        /// <param name="trigger"> Execution trigger of the storage task assignment. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="trigger"/> is null. </exception>
        public StorageTaskAssignmentExecutionContext(ExecutionTrigger trigger)
        {
            Argument.AssertNotNull(trigger, nameof(trigger));

            Trigger = trigger;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentExecutionContext"/>. </summary>
        /// <param name="target"> Execution target of the storage task assignment. </param>
        /// <param name="trigger"> Execution trigger of the storage task assignment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageTaskAssignmentExecutionContext(ExecutionTarget target, ExecutionTrigger trigger, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Target = target;
            Trigger = trigger;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskAssignmentExecutionContext"/> for deserialization. </summary>
        internal StorageTaskAssignmentExecutionContext()
        {
        }

        /// <summary> Execution target of the storage task assignment. </summary>
        [WirePath("target")]
        public ExecutionTarget Target { get; set; }
        /// <summary> Execution trigger of the storage task assignment. </summary>
        [WirePath("trigger")]
        public ExecutionTrigger Trigger { get; set; }
    }
}
