// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType. </summary>
    public readonly partial struct StorageSkuName : IEquatable<StorageSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardLrsValue = "Standard_LRS";
        private const string StandardGrsValue = "Standard_GRS";
        private const string StandardRagrsValue = "Standard_RAGRS";
        private const string StandardZrsValue = "Standard_ZRS";
        private const string PremiumLrsValue = "Premium_LRS";
        private const string PremiumZrsValue = "Premium_ZRS";
        private const string StandardGzrsValue = "Standard_GZRS";
        private const string StandardRagzrsValue = "Standard_RAGZRS";

        /// <summary> Standard_LRS. </summary>
        public static StorageSkuName StandardLrs { get; } = new StorageSkuName(StandardLrsValue);
        /// <summary> Standard_GRS. </summary>
        public static StorageSkuName StandardGrs { get; } = new StorageSkuName(StandardGrsValue);
        /// <summary> Standard_RAGRS. </summary>
        public static StorageSkuName StandardRagrs { get; } = new StorageSkuName(StandardRagrsValue);
        /// <summary> Standard_ZRS. </summary>
        public static StorageSkuName StandardZrs { get; } = new StorageSkuName(StandardZrsValue);
        /// <summary> Premium_LRS. </summary>
        public static StorageSkuName PremiumLrs { get; } = new StorageSkuName(PremiumLrsValue);
        /// <summary> Premium_ZRS. </summary>
        public static StorageSkuName PremiumZrs { get; } = new StorageSkuName(PremiumZrsValue);
        /// <summary> Standard_GZRS. </summary>
        public static StorageSkuName StandardGzrs { get; } = new StorageSkuName(StandardGzrsValue);
        /// <summary> Standard_RAGZRS. </summary>
        public static StorageSkuName StandardRagzrs { get; } = new StorageSkuName(StandardRagzrsValue);
        /// <summary> Determines if two <see cref="StorageSkuName"/> values are the same. </summary>
        public static bool operator ==(StorageSkuName left, StorageSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageSkuName"/> values are not the same. </summary>
        public static bool operator !=(StorageSkuName left, StorageSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageSkuName"/>. </summary>
        public static implicit operator StorageSkuName(string value) => new StorageSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
