// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The StorageSignedIdentifier. </summary>
    public partial class StorageSignedIdentifier
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageSignedIdentifier"/>. </summary>
        public StorageSignedIdentifier()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageSignedIdentifier"/>. </summary>
        /// <param name="id"> An unique identifier of the stored access policy. </param>
        /// <param name="accessPolicy"> Access policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageSignedIdentifier(string id, StorageServiceAccessPolicy accessPolicy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            AccessPolicy = accessPolicy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An unique identifier of the stored access policy. </summary>
        [WirePath("id")]
        public string Id { get; set; }
        /// <summary> Access policy. </summary>
        [WirePath("accessPolicy")]
        public StorageServiceAccessPolicy AccessPolicy { get; set; }
    }
}
