// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Routing Choice defines the kind of network routing opted by the user. </summary>
    public readonly partial struct StorageRoutingChoice : IEquatable<StorageRoutingChoice>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageRoutingChoice"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageRoutingChoice(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftRoutingValue = "MicrosoftRouting";
        private const string InternetRoutingValue = "InternetRouting";

        /// <summary> MicrosoftRouting. </summary>
        public static StorageRoutingChoice MicrosoftRouting { get; } = new StorageRoutingChoice(MicrosoftRoutingValue);
        /// <summary> InternetRouting. </summary>
        public static StorageRoutingChoice InternetRouting { get; } = new StorageRoutingChoice(InternetRoutingValue);
        /// <summary> Determines if two <see cref="StorageRoutingChoice"/> values are the same. </summary>
        public static bool operator ==(StorageRoutingChoice left, StorageRoutingChoice right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageRoutingChoice"/> values are not the same. </summary>
        public static bool operator !=(StorageRoutingChoice left, StorageRoutingChoice right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageRoutingChoice"/>. </summary>
        public static implicit operator StorageRoutingChoice(string value) => new StorageRoutingChoice(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageRoutingChoice other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageRoutingChoice other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
