// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC. </summary>
    public readonly partial struct StorageRestrictionReasonCode : IEquatable<StorageRestrictionReasonCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageRestrictionReasonCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageRestrictionReasonCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QuotaIdValue = "QuotaId";
        private const string NotAvailableForSubscriptionValue = "NotAvailableForSubscription";

        /// <summary> QuotaId. </summary>
        public static StorageRestrictionReasonCode QuotaId { get; } = new StorageRestrictionReasonCode(QuotaIdValue);
        /// <summary> NotAvailableForSubscription. </summary>
        public static StorageRestrictionReasonCode NotAvailableForSubscription { get; } = new StorageRestrictionReasonCode(NotAvailableForSubscriptionValue);
        /// <summary> Determines if two <see cref="StorageRestrictionReasonCode"/> values are the same. </summary>
        public static bool operator ==(StorageRestrictionReasonCode left, StorageRestrictionReasonCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageRestrictionReasonCode"/> values are not the same. </summary>
        public static bool operator !=(StorageRestrictionReasonCode left, StorageRestrictionReasonCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageRestrictionReasonCode"/>. </summary>
        public static implicit operator StorageRestrictionReasonCode(string value) => new StorageRestrictionReasonCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageRestrictionReasonCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageRestrictionReasonCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
