// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Allow, disallow, or let Network Security Perimeter configuration to evaluate public network access to Storage Account. Value is optional but if passed in, must be 'Enabled', 'Disabled' or 'SecuredByPerimeter'. </summary>
    public readonly partial struct StoragePublicNetworkAccess : IEquatable<StoragePublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StoragePublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StoragePublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string SecuredByPerimeterValue = "SecuredByPerimeter";

        /// <summary> Enabled. </summary>
        public static StoragePublicNetworkAccess Enabled { get; } = new StoragePublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static StoragePublicNetworkAccess Disabled { get; } = new StoragePublicNetworkAccess(DisabledValue);
        /// <summary> SecuredByPerimeter. </summary>
        public static StoragePublicNetworkAccess SecuredByPerimeter { get; } = new StoragePublicNetworkAccess(SecuredByPerimeterValue);
        /// <summary> Determines if two <see cref="StoragePublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(StoragePublicNetworkAccess left, StoragePublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StoragePublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(StoragePublicNetworkAccess left, StoragePublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StoragePublicNetworkAccess"/>. </summary>
        public static implicit operator StoragePublicNetworkAccess(string value) => new StoragePublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StoragePublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StoragePublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
