// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Storage.Models
{
    internal static partial class StorageNetworkDefaultActionExtensions
    {
        public static string ToSerialString(this StorageNetworkDefaultAction value) => value switch
        {
            StorageNetworkDefaultAction.Allow => "Allow",
            StorageNetworkDefaultAction.Deny => "Deny",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageNetworkDefaultAction value.")
        };

        public static StorageNetworkDefaultAction ToStorageNetworkDefaultAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Allow")) return StorageNetworkDefaultAction.Allow;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deny")) return StorageNetworkDefaultAction.Deny;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageNetworkDefaultAction value.");
        }
    }
}
