// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics. </summary>
    public readonly partial struct StorageNetworkBypass : IEquatable<StorageNetworkBypass>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageNetworkBypass"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageNetworkBypass(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string LoggingValue = "Logging";
        private const string MetricsValue = "Metrics";
        private const string AzureServicesValue = "AzureServices";

        /// <summary> None. </summary>
        public static StorageNetworkBypass None { get; } = new StorageNetworkBypass(NoneValue);
        /// <summary> Logging. </summary>
        public static StorageNetworkBypass Logging { get; } = new StorageNetworkBypass(LoggingValue);
        /// <summary> Metrics. </summary>
        public static StorageNetworkBypass Metrics { get; } = new StorageNetworkBypass(MetricsValue);
        /// <summary> AzureServices. </summary>
        public static StorageNetworkBypass AzureServices { get; } = new StorageNetworkBypass(AzureServicesValue);
        /// <summary> Determines if two <see cref="StorageNetworkBypass"/> values are the same. </summary>
        public static bool operator ==(StorageNetworkBypass left, StorageNetworkBypass right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageNetworkBypass"/> values are not the same. </summary>
        public static bool operator !=(StorageNetworkBypass left, StorageNetworkBypass right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageNetworkBypass"/>. </summary>
        public static implicit operator StorageNetworkBypass(string value) => new StorageNetworkBypass(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageNetworkBypass other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageNetworkBypass other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
