// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. </summary>
    public readonly partial struct StorageMinimumTlsVersion : IEquatable<StorageMinimumTlsVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageMinimumTlsVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageMinimumTlsVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Tls1_0Value = "TLS1_0";
        private const string Tls1_1Value = "TLS1_1";
        private const string Tls1_2Value = "TLS1_2";
        private const string Tls1_3Value = "TLS1_3";
        /// <summary> Determines if two <see cref="StorageMinimumTlsVersion"/> values are the same. </summary>
        public static bool operator ==(StorageMinimumTlsVersion left, StorageMinimumTlsVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageMinimumTlsVersion"/> values are not the same. </summary>
        public static bool operator !=(StorageMinimumTlsVersion left, StorageMinimumTlsVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageMinimumTlsVersion"/>. </summary>
        public static implicit operator StorageMinimumTlsVersion(string value) => new StorageMinimumTlsVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageMinimumTlsVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageMinimumTlsVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
