// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The lease status of the container. </summary>
    public readonly partial struct StorageLeaseStatus : IEquatable<StorageLeaseStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageLeaseStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageLeaseStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LockedValue = "Locked";
        private const string UnlockedValue = "Unlocked";

        /// <summary> Locked. </summary>
        public static StorageLeaseStatus Locked { get; } = new StorageLeaseStatus(LockedValue);
        /// <summary> Unlocked. </summary>
        public static StorageLeaseStatus Unlocked { get; } = new StorageLeaseStatus(UnlockedValue);
        /// <summary> Determines if two <see cref="StorageLeaseStatus"/> values are the same. </summary>
        public static bool operator ==(StorageLeaseStatus left, StorageLeaseStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageLeaseStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageLeaseStatus left, StorageLeaseStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageLeaseStatus"/>. </summary>
        public static implicit operator StorageLeaseStatus(string value) => new StorageLeaseStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageLeaseStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageLeaseStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
