// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used. </summary>
    public readonly partial struct StorageEncryptionKeyType : IEquatable<StorageEncryptionKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageEncryptionKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageEncryptionKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServiceValue = "Service";
        private const string AccountValue = "Account";

        /// <summary> Service. </summary>
        public static StorageEncryptionKeyType Service { get; } = new StorageEncryptionKeyType(ServiceValue);
        /// <summary> Account. </summary>
        public static StorageEncryptionKeyType Account { get; } = new StorageEncryptionKeyType(AccountValue);
        /// <summary> Determines if two <see cref="StorageEncryptionKeyType"/> values are the same. </summary>
        public static bool operator ==(StorageEncryptionKeyType left, StorageEncryptionKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageEncryptionKeyType"/> values are not the same. </summary>
        public static bool operator !=(StorageEncryptionKeyType left, StorageEncryptionKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageEncryptionKeyType"/>. </summary>
        public static implicit operator StorageEncryptionKeyType(string value) => new StorageEncryptionKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageEncryptionKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageEncryptionKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
