// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The custom domain assigned to this storage account. This can be set via Update. </summary>
    public partial class StorageCustomDomain
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageCustomDomain"/>. </summary>
        /// <param name="name"> Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public StorageCustomDomain(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="StorageCustomDomain"/>. </summary>
        /// <param name="name"> Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source. </param>
        /// <param name="isUseSubDomainNameEnabled"> Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageCustomDomain(string name, bool? isUseSubDomainNameEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IsUseSubDomainNameEnabled = isUseSubDomainNameEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageCustomDomain"/> for deserialization. </summary>
        internal StorageCustomDomain()
        {
        }

        /// <summary> Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates. </summary>
        [WirePath("useSubDomainName")]
        public bool? IsUseSubDomainNameEnabled { get; set; }
    }
}
