// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Sets the CORS rules. You can include up to five CorsRule elements in the request. </summary>
    internal partial class StorageCorsRules
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageCorsRules"/>. </summary>
        public StorageCorsRules()
        {
            CorsRules = new ChangeTrackingList<StorageCorsRule>();
        }

        /// <summary> Initializes a new instance of <see cref="StorageCorsRules"/>. </summary>
        /// <param name="corsRules"> The List of CORS rules. You can include up to five CorsRule elements in the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageCorsRules(IList<StorageCorsRule> corsRules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CorsRules = corsRules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The List of CORS rules. You can include up to five CorsRule elements in the request. </summary>
        [WirePath("corsRules")]
        public IList<StorageCorsRule> CorsRules { get; }
    }
}
