// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Storage.Models
{
    internal static partial class StorageAccountStatusExtensions
    {
        public static string ToSerialString(this StorageAccountStatus value) => value switch
        {
            StorageAccountStatus.Available => "available",
            StorageAccountStatus.Unavailable => "unavailable",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageAccountStatus value.")
        };

        public static StorageAccountStatus ToStorageAccountStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "available")) return StorageAccountStatus.Available;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "unavailable")) return StorageAccountStatus.Unavailable;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageAccountStatus value.");
        }
    }
}
