// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> This defines the sku conversion status object for asynchronous sku conversions. </summary>
    public partial class StorageAccountSkuConversionStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageAccountSkuConversionStatus"/>. </summary>
        public StorageAccountSkuConversionStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountSkuConversionStatus"/>. </summary>
        /// <param name="skuConversionStatus"> This property indicates the current sku conversion status. </param>
        /// <param name="targetSkuName"> This property represents the target sku name to which the account sku is being converted asynchronously. </param>
        /// <param name="startOn"> This property represents the sku conversion start time. </param>
        /// <param name="endOn"> This property represents the sku conversion end time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageAccountSkuConversionStatus(StorageAccountSkuConversionState? skuConversionStatus, StorageSkuName? targetSkuName, DateTimeOffset? startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SkuConversionStatus = skuConversionStatus;
            TargetSkuName = targetSkuName;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> This property indicates the current sku conversion status. </summary>
        [WirePath("skuConversionStatus")]
        public StorageAccountSkuConversionState? SkuConversionStatus { get; }
        /// <summary> This property represents the target sku name to which the account sku is being converted asynchronously. </summary>
        [WirePath("targetSkuName")]
        public StorageSkuName? TargetSkuName { get; set; }
        /// <summary> This property represents the sku conversion start time. </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> This property represents the sku conversion end time. </summary>
        [WirePath("endTime")]
        public DateTimeOffset? EndOn { get; }
    }
}
