// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). </summary>
    public readonly partial struct StorageAccountSasSignedService : IEquatable<StorageAccountSasSignedService>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountSasSignedService"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountSasSignedService(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BValue = "b";
        private const string QValue = "q";
        private const string TValue = "t";
        private const string FValue = "f";

        /// <summary> b. </summary>
        public static StorageAccountSasSignedService B { get; } = new StorageAccountSasSignedService(BValue);
        /// <summary> q. </summary>
        public static StorageAccountSasSignedService Q { get; } = new StorageAccountSasSignedService(QValue);
        /// <summary> t. </summary>
        public static StorageAccountSasSignedService T { get; } = new StorageAccountSasSignedService(TValue);
        /// <summary> f. </summary>
        public static StorageAccountSasSignedService F { get; } = new StorageAccountSasSignedService(FValue);
        /// <summary> Determines if two <see cref="StorageAccountSasSignedService"/> values are the same. </summary>
        public static bool operator ==(StorageAccountSasSignedService left, StorageAccountSasSignedService right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountSasSignedService"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountSasSignedService left, StorageAccountSasSignedService right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountSasSignedService"/>. </summary>
        public static implicit operator StorageAccountSasSignedService(string value) => new StorageAccountSasSignedService(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountSasSignedService other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountSasSignedService other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
