// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. </summary>
    public readonly partial struct StorageAccountSasSignedResourceType : IEquatable<StorageAccountSasSignedResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountSasSignedResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountSasSignedResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SValue = "s";
        private const string CValue = "c";
        private const string OValue = "o";

        /// <summary> s. </summary>
        public static StorageAccountSasSignedResourceType S { get; } = new StorageAccountSasSignedResourceType(SValue);
        /// <summary> c. </summary>
        public static StorageAccountSasSignedResourceType C { get; } = new StorageAccountSasSignedResourceType(CValue);
        /// <summary> o. </summary>
        public static StorageAccountSasSignedResourceType O { get; } = new StorageAccountSasSignedResourceType(OValue);
        /// <summary> Determines if two <see cref="StorageAccountSasSignedResourceType"/> values are the same. </summary>
        public static bool operator ==(StorageAccountSasSignedResourceType left, StorageAccountSasSignedResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountSasSignedResourceType"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountSasSignedResourceType left, StorageAccountSasSignedResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountSasSignedResourceType"/>. </summary>
        public static implicit operator StorageAccountSasSignedResourceType(string value) => new StorageAccountSasSignedResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountSasSignedResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountSasSignedResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
