// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Gets the state of virtual network rule. </summary>
    public readonly partial struct StorageAccountNetworkRuleState : IEquatable<StorageAccountNetworkRuleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountNetworkRuleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountNetworkRuleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string DeprovisioningValue = "Deprovisioning";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string NetworkSourceDeletedValue = "NetworkSourceDeleted";

        /// <summary> Provisioning. </summary>
        public static StorageAccountNetworkRuleState Provisioning { get; } = new StorageAccountNetworkRuleState(ProvisioningValue);
        /// <summary> Deprovisioning. </summary>
        public static StorageAccountNetworkRuleState Deprovisioning { get; } = new StorageAccountNetworkRuleState(DeprovisioningValue);
        /// <summary> Succeeded. </summary>
        public static StorageAccountNetworkRuleState Succeeded { get; } = new StorageAccountNetworkRuleState(SucceededValue);
        /// <summary> Failed. </summary>
        public static StorageAccountNetworkRuleState Failed { get; } = new StorageAccountNetworkRuleState(FailedValue);
        /// <summary> NetworkSourceDeleted. </summary>
        public static StorageAccountNetworkRuleState NetworkSourceDeleted { get; } = new StorageAccountNetworkRuleState(NetworkSourceDeletedValue);
        /// <summary> Determines if two <see cref="StorageAccountNetworkRuleState"/> values are the same. </summary>
        public static bool operator ==(StorageAccountNetworkRuleState left, StorageAccountNetworkRuleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountNetworkRuleState"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountNetworkRuleState left, StorageAccountNetworkRuleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountNetworkRuleState"/>. </summary>
        public static implicit operator StorageAccountNetworkRuleState(string value) => new StorageAccountNetworkRuleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountNetworkRuleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountNetworkRuleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
