// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Network rule set. </summary>
    public partial class StorageAccountNetworkRuleSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageAccountNetworkRuleSet"/>. </summary>
        /// <param name="defaultAction"> Specifies the default action of allow or deny when no other rules match. </param>
        public StorageAccountNetworkRuleSet(StorageNetworkDefaultAction defaultAction)
        {
            ResourceAccessRules = new ChangeTrackingList<StorageAccountResourceAccessRule>();
            VirtualNetworkRules = new ChangeTrackingList<StorageAccountVirtualNetworkRule>();
            IPRules = new ChangeTrackingList<StorageAccountIPRule>();
            DefaultAction = defaultAction;
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountNetworkRuleSet"/>. </summary>
        /// <param name="bypass"> Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics. </param>
        /// <param name="resourceAccessRules"> Sets the resource access rules. </param>
        /// <param name="virtualNetworkRules"> Sets the virtual network rules. </param>
        /// <param name="ipRules"> Sets the IP ACL rules. </param>
        /// <param name="defaultAction"> Specifies the default action of allow or deny when no other rules match. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageAccountNetworkRuleSet(StorageNetworkBypass? bypass, IList<StorageAccountResourceAccessRule> resourceAccessRules, IList<StorageAccountVirtualNetworkRule> virtualNetworkRules, IList<StorageAccountIPRule> ipRules, StorageNetworkDefaultAction defaultAction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Bypass = bypass;
            ResourceAccessRules = resourceAccessRules;
            VirtualNetworkRules = virtualNetworkRules;
            IPRules = ipRules;
            DefaultAction = defaultAction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountNetworkRuleSet"/> for deserialization. </summary>
        internal StorageAccountNetworkRuleSet()
        {
        }

        /// <summary> Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics. </summary>
        [WirePath("bypass")]
        public StorageNetworkBypass? Bypass { get; set; }
        /// <summary> Sets the resource access rules. </summary>
        [WirePath("resourceAccessRules")]
        public IList<StorageAccountResourceAccessRule> ResourceAccessRules { get; }
        /// <summary> Sets the virtual network rules. </summary>
        [WirePath("virtualNetworkRules")]
        public IList<StorageAccountVirtualNetworkRule> VirtualNetworkRules { get; }
        /// <summary> Sets the IP ACL rules. </summary>
        [WirePath("ipRules")]
        public IList<StorageAccountIPRule> IPRules { get; }
        /// <summary> Specifies the default action of allow or deny when no other rules match. </summary>
        [WirePath("defaultAction")]
        public StorageNetworkDefaultAction DefaultAction { get; set; }
    }
}
