// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Current status of migration. </summary>
    public readonly partial struct StorageAccountMigrationStatus : IEquatable<StorageAccountMigrationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountMigrationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountMigrationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string SubmittedForConversionValue = "SubmittedForConversion";
        private const string InProgressValue = "InProgress";
        private const string CompleteValue = "Complete";
        private const string FailedValue = "Failed";

        /// <summary> Invalid. </summary>
        public static StorageAccountMigrationStatus Invalid { get; } = new StorageAccountMigrationStatus(InvalidValue);
        /// <summary> SubmittedForConversion. </summary>
        public static StorageAccountMigrationStatus SubmittedForConversion { get; } = new StorageAccountMigrationStatus(SubmittedForConversionValue);
        /// <summary> InProgress. </summary>
        public static StorageAccountMigrationStatus InProgress { get; } = new StorageAccountMigrationStatus(InProgressValue);
        /// <summary> Complete. </summary>
        public static StorageAccountMigrationStatus Complete { get; } = new StorageAccountMigrationStatus(CompleteValue);
        /// <summary> Failed. </summary>
        public static StorageAccountMigrationStatus Failed { get; } = new StorageAccountMigrationStatus(FailedValue);
        /// <summary> Determines if two <see cref="StorageAccountMigrationStatus"/> values are the same. </summary>
        public static bool operator ==(StorageAccountMigrationStatus left, StorageAccountMigrationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountMigrationStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountMigrationStatus left, StorageAccountMigrationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountMigrationStatus"/>. </summary>
        public static implicit operator StorageAccountMigrationStatus(string value) => new StorageAccountMigrationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountMigrationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountMigrationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
