// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. </summary>
    public readonly partial struct StorageAccountKeySource : IEquatable<StorageAccountKeySource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountKeySource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountKeySource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StorageValue = "Microsoft.Storage";
        private const string KeyVaultValue = "Microsoft.Keyvault";

        /// <summary> Microsoft.Storage. </summary>
        public static StorageAccountKeySource Storage { get; } = new StorageAccountKeySource(StorageValue);
        /// <summary> Microsoft.Keyvault. </summary>
        public static StorageAccountKeySource KeyVault { get; } = new StorageAccountKeySource(KeyVaultValue);
        /// <summary> Determines if two <see cref="StorageAccountKeySource"/> values are the same. </summary>
        public static bool operator ==(StorageAccountKeySource left, StorageAccountKeySource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountKeySource"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountKeySource left, StorageAccountKeySource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountKeySource"/>. </summary>
        public static implicit operator StorageAccountKeySource(string value) => new StorageAccountKeySource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountKeySource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountKeySource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
