// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object. </summary>
    public partial class StorageAccountEndpoints
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageAccountEndpoints"/>. </summary>
        internal StorageAccountEndpoints()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountEndpoints"/>. </summary>
        /// <param name="blobUri"> Gets the blob endpoint. </param>
        /// <param name="queueUri"> Gets the queue endpoint. </param>
        /// <param name="tableUri"> Gets the table endpoint. </param>
        /// <param name="fileUri"> Gets the file endpoint. </param>
        /// <param name="webUri"> Gets the web endpoint. </param>
        /// <param name="dfsUri"> Gets the dfs endpoint. </param>
        /// <param name="microsoftEndpoints"> Gets the microsoft routing storage endpoints. </param>
        /// <param name="internetEndpoints"> Gets the internet routing storage endpoints. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageAccountEndpoints(Uri blobUri, Uri queueUri, Uri tableUri, Uri fileUri, Uri webUri, Uri dfsUri, StorageAccountMicrosoftEndpoints microsoftEndpoints, StorageAccountInternetEndpoints internetEndpoints, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlobUri = blobUri;
            QueueUri = queueUri;
            TableUri = tableUri;
            FileUri = fileUri;
            WebUri = webUri;
            DfsUri = dfsUri;
            MicrosoftEndpoints = microsoftEndpoints;
            InternetEndpoints = internetEndpoints;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the blob endpoint. </summary>
        [WirePath("blob")]
        public Uri BlobUri { get; }
        /// <summary> Gets the queue endpoint. </summary>
        [WirePath("queue")]
        public Uri QueueUri { get; }
        /// <summary> Gets the table endpoint. </summary>
        [WirePath("table")]
        public Uri TableUri { get; }
        /// <summary> Gets the file endpoint. </summary>
        [WirePath("file")]
        public Uri FileUri { get; }
        /// <summary> Gets the web endpoint. </summary>
        [WirePath("web")]
        public Uri WebUri { get; }
        /// <summary> Gets the dfs endpoint. </summary>
        [WirePath("dfs")]
        public Uri DfsUri { get; }
        /// <summary> Gets the microsoft routing storage endpoints. </summary>
        [WirePath("microsoftEndpoints")]
        public StorageAccountMicrosoftEndpoints MicrosoftEndpoints { get; }
        /// <summary> Gets the internet routing storage endpoints. </summary>
        [WirePath("internetEndpoints")]
        public StorageAccountInternetEndpoints InternetEndpoints { get; }
    }
}
