// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Encryption identity for the storage account. </summary>
    public partial class StorageAccountEncryptionIdentity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageAccountEncryptionIdentity"/>. </summary>
        public StorageAccountEncryptionIdentity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountEncryptionIdentity"/>. </summary>
        /// <param name="encryptionUserAssignedIdentity"> Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account. </param>
        /// <param name="encryptionFederatedIdentityClientId"> ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageAccountEncryptionIdentity(string encryptionUserAssignedIdentity, string encryptionFederatedIdentityClientId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EncryptionUserAssignedIdentity = encryptionUserAssignedIdentity;
            EncryptionFederatedIdentityClientId = encryptionFederatedIdentityClientId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account. </summary>
        [WirePath("userAssignedIdentity")]
        public string EncryptionUserAssignedIdentity { get; set; }
        /// <summary> ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account. </summary>
        [WirePath("federatedIdentityClientId")]
        public string EncryptionFederatedIdentityClientId { get; set; }
    }
}
