// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Storage.Models
{
    internal static partial class StorageAccountAccessTierExtensions
    {
        public static string ToSerialString(this StorageAccountAccessTier value) => value switch
        {
            StorageAccountAccessTier.Hot => "Hot",
            StorageAccountAccessTier.Cool => "Cool",
            StorageAccountAccessTier.Premium => "Premium",
            StorageAccountAccessTier.Cold => "Cold",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageAccountAccessTier value.")
        };

        public static StorageAccountAccessTier ToStorageAccountAccessTier(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Hot")) return StorageAccountAccessTier.Hot;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cool")) return StorageAccountAccessTier.Cool;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return StorageAccountAccessTier.Premium;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cold")) return StorageAccountAccessTier.Cold;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageAccountAccessTier value.");
        }
    }
}
