// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Storage.Models
{
    public partial class SmbSetting : IUtf8JsonSerializable, IJsonModel<SmbSetting>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SmbSetting>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SmbSetting>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmbSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SmbSetting)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Multichannel))
            {
                writer.WritePropertyName("multichannel"u8);
                writer.WriteObjectValue(Multichannel, options);
            }
            if (Optional.IsDefined(Versions))
            {
                writer.WritePropertyName("versions"u8);
                writer.WriteStringValue(Versions);
            }
            if (Optional.IsDefined(AuthenticationMethods))
            {
                writer.WritePropertyName("authenticationMethods"u8);
                writer.WriteStringValue(AuthenticationMethods);
            }
            if (Optional.IsDefined(KerberosTicketEncryption))
            {
                writer.WritePropertyName("kerberosTicketEncryption"u8);
                writer.WriteStringValue(KerberosTicketEncryption);
            }
            if (Optional.IsDefined(ChannelEncryption))
            {
                writer.WritePropertyName("channelEncryption"u8);
                writer.WriteStringValue(ChannelEncryption);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SmbSetting IJsonModel<SmbSetting>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmbSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SmbSetting)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSmbSetting(document.RootElement, options);
        }

        internal static SmbSetting DeserializeSmbSetting(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Multichannel multichannel = default;
            string versions = default;
            string authenticationMethods = default;
            string kerberosTicketEncryption = default;
            string channelEncryption = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("multichannel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    multichannel = Multichannel.DeserializeMultichannel(property.Value, options);
                    continue;
                }
                if (property.NameEquals("versions"u8))
                {
                    versions = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authenticationMethods"u8))
                {
                    authenticationMethods = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("kerberosTicketEncryption"u8))
                {
                    kerberosTicketEncryption = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("channelEncryption"u8))
                {
                    channelEncryption = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SmbSetting(
                multichannel,
                versions,
                authenticationMethods,
                kerberosTicketEncryption,
                channelEncryption,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsMultiChannelEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  multichannel: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Multichannel))
                {
                    builder.Append("  multichannel: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Multichannel, options, 2, false, "  multichannel: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Versions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  versions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Versions))
                {
                    builder.Append("  versions: ");
                    if (Versions.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Versions}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Versions}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthenticationMethods), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authenticationMethods: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthenticationMethods))
                {
                    builder.Append("  authenticationMethods: ");
                    if (AuthenticationMethods.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AuthenticationMethods}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AuthenticationMethods}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KerberosTicketEncryption), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kerberosTicketEncryption: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KerberosTicketEncryption))
                {
                    builder.Append("  kerberosTicketEncryption: ");
                    if (KerberosTicketEncryption.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{KerberosTicketEncryption}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{KerberosTicketEncryption}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ChannelEncryption), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  channelEncryption: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ChannelEncryption))
                {
                    builder.Append("  channelEncryption: ");
                    if (ChannelEncryption.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ChannelEncryption}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ChannelEncryption}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SmbSetting>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmbSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SmbSetting)} does not support writing '{options.Format}' format.");
            }
        }

        SmbSetting IPersistableModel<SmbSetting>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmbSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSmbSetting(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SmbSetting)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SmbSetting>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
